"use client";
import authBg from "@/assets/auth/auth-bg.png";
import authElem1 from "@/assets/auth/auth-elem-1.svg";
import authElem2 from "@/assets/auth/auth-elem-2.svg";
import LanguageDropdown from "@/components/dashboard/UserDropdown/LanguageDropdown";
import { useSettings } from "@/context/settingsContext";
import { useT } from "@/context/TranslationContext";
import ApiPath from "@/network/api/apiPath";
import NetworkService from "@/network/service/networkService";
import TokenService from "@/network/service/tokenService";
import { getSettingValue } from "@/utils/utils";
import { Icon } from "@iconify/react";
import Image from "next/image";
import Link from "next/link";
import { usePathname, useRouter, useSearchParams } from "next/navigation";
import { useEffect, useState } from "react";

const RegisterPassword = () => {
  const network = new NetworkService();
  const tokenService = new TokenService();
  const [password, setPassword] = useState("");
  const [confirmPassword, setConfirmPassword] = useState("");
  const [showPassword, setShowPassword] = useState(false);
  const [showConfirmPassword, setShowConfirmPassword] = useState(false);
  const pathname = usePathname();
  const searchParams = useSearchParams();
  const email = searchParams.get("email");
  const router = useRouter();
  const [loading, setLoading] = useState(false);
  const landingUrl = process.env.NEXT_PUBLIC_LANDING_PAGE || "/";
  const { settings } = useSettings();
  const siteLogo = getSettingValue(settings, "site_logo");
  const siteLogoHeight = getSettingValue(settings, "site_logo_height");
  const t = useT();

  // handle password submit
  const handlePasswordSubmit = async (e) => {
    e.preventDefault();
    try {
      const requestBody = {
        email: email,
        password: password,
        password_confirmation: confirmPassword,
        i_agree: "1",
        is_email_verified: "1",
      };

      setLoading(true);
      const res = await network.post(ApiPath.register, requestBody);
      if (res.status === "completed") {
        const token = res.data.data.token;
        await network.tokenService.saveAccessToken(token);
        // toast.success(res.data.message);
        router.push("/auth/register/register-password-success");
      }
    } finally {
      setLoading(false);
    }
  };

  // effects
  useEffect(() => {
    if (!email) {
      router.push("/auth/register");
    }
  }, [email, router]);

  return (
    <div className="flex">
      <div className="left w-full lg:w-[50%] me-0 lg:me-[50%] min-h-screen relative">
        <div className="absolute top-4 start-4">
          <LanguageDropdown authpage={true} />
        </div>
        <div className="left-content flex justify-center items-center min-h-screen pt-[100px] xl:pt-24 pb-[100px] xl:pb-24">
          <div className="min-w-full sm:min-w-[450px] mx-auto px-4 xl:px-0">
            <div className="mb-[40px]">
              <Link
                href={landingUrl}
                className={`block w-auto h-[${siteLogoHeight}px]`}
              >
                {siteLogo ? (
                  <Image
                    src={siteLogo}
                    unoptimized
                    alt="logo"
                    width={205}
                    height={50}
                    style={{ height: `${siteLogoHeight}px`, width: "auto" }}
                    className="h-full"
                  />
                ) : (
                  <div className="h-[30px] w-[100px] bg-gray-100 animate-pulse rounded"></div>
                )}
              </Link>
            </div>
            <h2 className="text-[24px] text-merchant-text font-bold mb-[12px]">
              {t("authPages.setupPasswordTitle")}
            </h2>
            <div className="mt-[40px]">
              <form onSubmit={handlePasswordSubmit}>
                <div className="grid grid-cols-12 gap-4 sm:gap-6">
                  <div className="col-span-12">
                    <div>
                      <div className="relative">
                        <input
                          type={showPassword ? "text" : "password"}
                          id="password"
                          className={`user-input user-input-left peer`}
                          placeholder=" "
                          value={password}
                          onChange={(e) => setPassword(e.target.value)}
                        />
                        <label
                          htmlFor="password"
                          className="user-label absolute -translate-y-4 scale-75 top-2 z-10 origin-[0] px-[30px] peer-focus:px-2 peer-focus:text-fg-brand peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-[90%] peer-focus:-translate-y-4  start-[16px]"
                        >
                          {t("label.password")}{" "}
                          <span className="text-merchant-error">*</span>
                        </label>
                        <div className="absolute rtl:right-[16px] ltr:left-[16px] top-[50%] -translate-y-1/2 z-[21]">
                          <Icon
                            icon="basil:lock-solid"
                            width="24"
                            height="24"
                            className="text-[#9A9DA2] h-[20px] w-[20px]"
                          />
                        </div>
                        <div
                          className="absolute rtl:left-[16px] ltr:right-[16px] top-1/2 -translate-y-1/2 z-20 cursor-pointer"
                          onMouseDown={(e) => e.preventDefault()}
                          onClick={() => setShowPassword(!showPassword)}
                        >
                          <Icon
                            icon={
                              showPassword
                                ? "basil:eye-solid"
                                : "basil:eye-closed-solid"
                            }
                            width="24"
                            height="24"
                            className="text-[#9A9DA2] h-[20px] w-[20px]"
                          />
                        </div>
                      </div>
                    </div>
                  </div>
                  <div className="col-span-12">
                    <div>
                      <div className="relative">
                        <input
                          type={showConfirmPassword ? "text" : "password"}
                          id="confirm_password"
                          className={`user-input user-input-left peer`}
                          placeholder=" "
                          value={confirmPassword}
                          onChange={(e) => setConfirmPassword(e.target.value)}
                        />
                        <label
                          htmlFor="confirm_password"
                          className="user-label absolute -translate-y-4 scale-75 top-2 z-10 origin-[0] px-[30px] peer-focus:px-2 peer-focus:text-fg-brand peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-[90%] peer-focus:-translate-y-4  start-[16px]"
                        >
                          {t("label.confirmPassword")}{" "}
                          <span className="text-merchant-error">*</span>
                        </label>
                        <div className="absolute rtl:right-[16px] ltr:left-[16px] top-[50%] -translate-y-1/2 z-[21]">
                          <Icon
                            icon="basil:lock-solid"
                            width="24"
                            height="24"
                            className="text-[#9A9DA2] h-[20px] w-[20px]"
                          />
                        </div>
                        <div
                          className="absolute rtl:left-[16px] ltr:right-[16px] top-1/2 -translate-y-1/2 z-20 cursor-pointer"
                          onMouseDown={(e) => e.preventDefault()}
                          onClick={() =>
                            setShowConfirmPassword(!showConfirmPassword)
                          }
                        >
                          <Icon
                            icon={
                              showConfirmPassword
                                ? "basil:eye-solid"
                                : "basil:eye-closed-solid"
                            }
                            width="24"
                            height="24"
                            className="text-[#9A9DA2] h-[20px] w-[20px]"
                          />
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <button
                  type="submit"
                  className="group primary-button w-full mt-5 sm:mt-[30px] lg:mt-[40px]"
                  disabled={loading}
                >
                  <span className="primary-button-hover-effect"></span>
                  <span className="primary-button-text">
                    {loading
                      ? t("authPages.continuing")
                      : t("authPages.continue")}
                  </span>
                </button>
              </form>
            </div>
            <div className="path-switch mt-[30px] md:mt-[60px]">
              <p className="text-center text-[14px] sm:text-[16px] font-medium text-merchant-paragraph">
                {t("authPages.alreadyHaveAnAccount")}{" "}
                <Link href="/auth/login" className="text-merchant-primary">
                  {t("authPages.signIn")}
                </Link>
              </p>
            </div>
          </div>
        </div>
        <div className="auth-elements">
          <div className="auth-elem-up absolute top-0 rtl:left-[30px] ltr:right-[30px]">
            <div className="w-[40px] md:w-[60px] xl:w-[80px] 3xl:w-[122px] h-auto">
              <Image
                src={authElem1}
                alt="Auth Element 1"
                className="w-full h-auto"
              />
            </div>
          </div>
          <div className="auth-elem-bottom absolute bottom-0 rtl:right-0 ltr:left-0">
            <div className="w-[60px] xl:w-[80px] 3xl:w-[122px] h-auto">
              <Image
                src={authElem2}
                alt="Auth Element 2"
                className="w-full h-auto rtl:scale-x-[-1]"
              />
            </div>
          </div>
        </div>
      </div>
      <div className="right w-[50%] min-h-screen fixed top-0 rtl:left-0 ltr:right-0 hidden lg:block">
        <div
          className="right-content bg-center bg-cover bg-no-repeat h-screen w-full"
          style={{ backgroundImage: `url(${authBg.src})` }}
        ></div>
      </div>
    </div>
  );
};

export default RegisterPassword;
